/*
* Creation date : Wed Mar 07 18:21:17 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* CE2_RSA_PRIM functions.
*
* \version CE2_RSA_PRIM.c#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_RSA_PRIM.h"
#include "LLF_RSA_PRIM.h"
#include "LLF_RSA_Common.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_RSA_PRIM_Encrypt
*
* Inputs:
*  @param UserPubKey_ptr [in] - A pointer to the public key data structure;
*  @param Data_ptr   [in] - A pointer to the data to encrypt;
*  @param DataSize   [in] - The size, in bytes, of the data to encrypt;
*  @param Output_ptr [out] - Pointer to the encrypted data.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PUB_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_DATA_POINTER_INVALID_ERROR,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_BUFFER_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_VAL.
*
* \brief \b
* Description:
*  CE2_RSA_PRIM_Encrypt implements the RSAEP algorithm as defined in
*  PKCS#1 v2.1 6.1.1
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RSA_PRIM_Encrypt
*     to encrypt data using public key with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RSA_PRIM_Encrypt(
                        CE2_RSAUserPubKey_t *UserPubKey_ptr,/* in */
                        DxUint8_t           *Data_ptr,		/* in */
                        DxUint16_t           DataSize,		/* in */
                        DxUint8_t           *Output_ptr)	/* out */
{
	DxUint32_t outLen = (DxUint32_t)(BITS2BYTES(((CE2RSAPubKey_t *)
		(UserPubKey_ptr->PublicKeyDbBuff))->nSizeInBits));

	if (UserPubKey_ptr == DX_NULL)
		return CE2_RSA_PRIM_ENCRYPT_INVALID_PUBKEY_PTR_ERROR;

	if (Data_ptr == DX_NULL && DataSize != 0 )
		return CE2_RSA_PRIM_ENCRYPT_INVALID_DATA_PTR_ERROR;

	if (Output_ptr == DX_NULL)
		return CE2_RSA_PRIM_ENCRYPT_INVALID_OUTPUT_PTR_ERROR;

	//return LLF_RSA_PRIM_Encrypt(UserPubKey_ptr, Data_ptr,
	//	DataSize, Output_ptr);
	return LLF_RSA_Encrypt(Data_ptr, DataSize, Output_ptr, 
		&outLen, UserPubKey_ptr);
} /* End of CE2_RSA_PRIM_Encrypt */

/**
****************************************************************
* Function Name: 
*  CE2_RSA_PRIM_Decrypt
*
* Inputs:
*  @param UserPrivKey_ptr [in] - Pointer to the private key data structure;
*  @param Data_ptr   [in] - A pointer to the data to be decrypted;
*  @param DataSize   [in] - The size, in bytes, of the data to decrypt;
*  @param Output_ptr [out] - A pointer to the decrypted data.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_PRIV_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_DATA_POINTER_INVALID_ERROR,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_MESSAGE_VAL.
*
* \brief \b
* Description:
*  CE2_RSA_PRIM_Decrypt implements the RSADP algorithm as defined in
*  PKCS#1 v2.1 6.1.2
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RSA_PRIM_Decrypt
*     to decrypt data using private key  with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RSA_PRIM_Decrypt(
                        CE2_RSAUserPrivKey_t *UserPrivKey_ptr, /* in */
                        DxUint8_t     *Data_ptr,	/* in */
                        DxUint16_t     DataSize,	/* in */
                        DxUint8_t     *Output_ptr)	/* out */
{
	DxUint32_t outLen = (DxUint32_t)(BITS2BYTES(((CE2RSAPrivKey_t *)
		(UserPrivKey_ptr->PrivateKeyDbBuff))->nSizeInBits));

	if (UserPrivKey_ptr == DX_NULL)
		return CE2_RSA_PRIM_DECRYPT_INVALID_PUBKEY_PTR_ERROR;

	if (Data_ptr == DX_NULL)
		return CE2_RSA_PRIM_DECRYPT_INVALID_DATA_PTR_ERROR;

	if (Output_ptr == DX_NULL)
		return CE2_RSA_PRIM_DECRYPT_INVALID_OUTPUT_PTR_ERROR;

	//return LLF_RSA_PRIM_Decrypt(UserPrivKey_ptr, Data_ptr,
	//	DataSize, Output_ptr);
	return LLF_RSA_Decrypt(Data_ptr, DataSize, Output_ptr, 
		&outLen, UserPrivKey_ptr);
} /* End of CE2_RSA_PRIM_Decrypt */
